<?php

/* --------------------------------------------------------------
   ContentSitemap.inc.php 2019-04-12
   Gambio GmbH
   http://www.gambio.de
   Copyright (c) 2019 Gambio GmbH
   Released under the GNU General Public License (Version 2)
   [http://www.gnu.org/licenses/gpl-2.0.html]
   --------------------------------------------------------------
*/

/**
 * Class ContentSitemap
 *
 * This class represents the content site map information
 *
 * @category   System
 * @package    Content
 */
class ContentSitemap implements ContentSitemapInterface
{
    /**
     * Site map content visibility
     *
     * @var bool
     */
    protected $visible;
    
    /**
     * Site map content priority for each language
     *
     * @var ContentSitemapPriorityCollection
     */
    protected $priorities;
    
    /**
     * Site map content change frequency
     *
     * @var string
     */
    protected $changeFrequency;
    
    
    /**
     * ContentSitemap constructor
     *
     * @param ContentSitemapVisibilityInterface      $visibility      Site map content visibility
     * @param ContentSitemapPriorityCollection       $priorities      Site map content priority collection
     * @param ContentSitemapChangeFrequencyInterface $changeFrequency Site map content change frequency
     */
    public function __construct(
        ContentSitemapVisibilityInterface $visibility,
        ContentSitemapPriorityCollection $priorities,
        ContentSitemapChangeFrequencyInterface $changeFrequency
    ) {
        $this->visible         = $visibility->isVisible();
        $this->priorities      = $priorities;
        $this->changeFrequency = $changeFrequency->frequencyOfChange();
    }
    
    
    /**
     * Return whether the content is visible in the site map
     *
     * @return bool
     */
    public function isVisible(): bool
    {
        return $this->visible;
    }
    
    
    /**
     * Return the site map content priority collection
     *
     * @return ContentSitemapPriorityCollection
     */
    public function priorities(): ContentSitemapPriorityCollection
    {
        return $this->priorities;
    }
    
    
    /**
     * Return the change frequency of the content
     *
     * @return string
     */
    public function frequencyOfChange(): string
    {
        return $this->changeFrequency;
    }
}